#include "vertexBufferObject.h"

// ----------------------------------------------------------------------------------------------------------------------------

class COpenGLControl
{
private:
	int Width, Height;
	mat4x4 ModelMatrix, ViewMatrix, ProjectionMatrix, ViewProjectionMatrix;
	
private:
	CTexture Textures[4];
	CShaderProgram SkyBox, Lighting;
	GLuint VBO[2], VAO[2];
	int VerticesCount[3];

public:
	CCamera Camera;

public:
	COpenGLControl();
	~COpenGLControl();

	bool Init();
	void Render(float FrameTime);
	void Resize(int Width, int Height);
	void Destroy();
};

// ----------------------------------------------------------------------------------------------------------------------------

vec3 SkyBoxVertices[];
vec2 GrassTexCoords[];
vec3 GrassVertices[];
vec2 CubeTexCoords[];
vec3 CubeNormals[];
vec3 CubeVertices[];

// ----------------------------------------------------------------------------------------------------------------------------

int GenerateTorus(CBuffer &Buffer, float Radius, float TubeRadius, int SubDivAround, int SubDivTube, mat4x4 &Model);
